set more off 
pause off
set logtype text
set mem 500M

tempfile currtemp

*************** DESCRIPTION ****************************************
* Loads and aggregates industry-level spread data 
* to NEA segments
*
*	Inputs: 	0.raw_inputs\spr_naics3_q.csv --> Avg. corporate bond 
*				spreads by NAICS-3 industry, provided by Simon Gilchrist 
*				and Egon Zakrajsek. 
*	Outputs: 	2.intermediate\spread_data --> weighted avg. spread
*				by BEA segment				
*********************************************************************  

*** ADD INDUSTRY SPREAD DATA AND GROUP INTO DESIRED BEA CODES ***
import delimited 0.raw_inputs\spr_naics3_q.csv, clear

g year = substr(date,1,4)
g qtr = substr(date,6,6)
keep if qtr == "4"
drop date
rename naics3 naics

destring, replace
save `currtemp', replace

* Map to BEA codes
import excel 1.user_inputs\NAICS2BEA.xlsx, firstrow clear
merge 1:m naics using `currtemp', keep(matched using) nogen
save `currtemp', replace

* Map to BEA segments 
merge m:1 beacode using 6.Temp\levelkey, keep(matched) nogen
g indcode = ind_short  

* Aggregate 
g nb_spavg = nbonds * spr_avg

keep indcode year nb_spavg nbonds
collapse (sum) nbonds nb_spavg , by (indcode year )
g a1m_spread = nb_spavg / nbonds

keep indcode year a1m_spread
save 2.intermediate\spread_data, replace

* Test
g test1 =  (a1m_spread - 2.1257) if indcode == "Dur_Wood" & year == 1974
su test*
drop test*
pause
